/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DriverLayerMCHP.cpp                                                *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/05/2007       1.0                              *
*******************************************************************************/

#ifdef _DRIVER_MICROCHIP

#include "DriverLayerMCHP.h"

driverLayerMCHP::driverLayerMCHP () {

    explenrecv = MAX_LEN_MSG;
    pl = new platformLayerWin32();
    findU4ABoards();
}

driverLayerMCHP::~driverLayerMCHP() {

    l->printLog("driverLayerMCHP Destructor",true,true);
    l = NULL;
    delete pl;
}

void driverLayerMCHP::findU4ABoards() {//Ok

    map<int,itemDsc> dscs;
    map<int,itemDsc>::iterator it;
    itemDsc ds;
    itemBoard itb;
    dscEndpoint ep;
    int temp, num;

    dscs = pl->getDescriptors();
    for (it = dscs.begin();it != dscs.end();it++) {
        ds = it->second;
        itb.serial = atoi((const char *)&ds.strSerialNumber[0]);
        itb.qtyep = ds.qtyep;
        for (int i=0 ; i < itb.qtyep ; i++){
            temp = (int)(((unsigned char)ds.stdEndpointDsc[i][3]) & 0x03);
            num = (int)((unsigned char)ds.stdEndpointDsc[i][2]);
            switch (temp) {
                case 0:
                    if (num > 127) {
                        ep.tdscin = CTRL_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                       ep.tdscin = NULL_IN;
                        ep.tdscout = CTRL_OUT;
                   }
                    break;
                case 1:
                    if (num > 127) {
                        ep.tdscin = ISO_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = ISO_OUT;
                    }
                    break;
                case 2:
                    if (num > 127) {
                        ep.tdscin = BULK_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = BULK_OUT;
                    }
                    break;
                case 3:
                    if (num > 127) {
                        ep.tdscin = INT_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = INT_OUT;
                    }
                    break;
            }
            ep.epnum = num;
            itb.eps[i] = ep;
        };
        boards.insert(pair<int,itemBoard>(it->first,itb));
    }
}

void driverLayerMCHP::dscToMCHP(int dsc, char *ep) { //Ok

    int nlen;
    char temp[10];

    sprintf(temp,"MCHP_EP%d",dsc);
    nlen = strlen(temp);
    ep[0] = '\\';
    for (int i = 0 ; i < nlen ; i++) {
        ep[i+1] = temp[i];
    };
    ep[nlen+1] = '\0';
}

int driverLayerMCHP::getInstance(int board) { //Ok

    return board;
};

int* driverLayerMCHP::getU4ABoards(int &cant) { //OK

    int *iboards;
    map<int,itemBoard>::iterator it;

    cant = boards.size();
    if (cant > 0) {
        iboards = new int[cant];
        for (int i=0; i < cant ; i++) {
            it = boards.find(i);
            iboards[i] = it->second.serial;
        };
        return iboards;
    };
    return NULL;
}

int driverLayerMCHP::qtyDsc(int board) { //Ok

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return (it->second.qtyep);
}

dscEndpoint* driverLayerMCHP::getEndpointDsc(int board, int iter) { //Ok

    map<int,itemBoard>::iterator it;
    dscEndpoint* endps;

    it = boards.find(board);
    endps = new dscEndpoint();
    endps->epnum = it->second.eps[iter].epnum;
    endps->tdscin = it->second.eps[iter].tdscin;
    endps->tdscout = it->second.eps[iter].tdscout;
    return endps;
}

int driverLayerMCHP::open(int board, int dsc, usbin dscin) {

    char vidpid[] = "vid_04d8&pid_000c";
    char ep[10];
    int nbuff, inst;
    char buffer[MAX_LEN_MSG];

    inst = getInstance(board);
    dscToMCHP(dsc, ep);
    l->printLog(ep,true,true);
    nbuff = (int) MPUSBOpen(inst, vidpid, ep, MP_READ,0);
    sprintf(buffer,"%d",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

int driverLayerMCHP::open(int board, int dsc, usbout dscout) {

    char vidpid[] = "vid_04d8&pid_000c";
    char ep[10];
    int nbuff, inst;
    char buffer[MAX_LEN_MSG];

    inst = getInstance(board);
    dscToMCHP(dsc, ep);
    l->printLog(ep,true,true);
    nbuff = (int) MPUSBOpen(inst, vidpid, ep, MP_WRITE,0);
    sprintf(buffer,"%d",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

bool driverLayerMCHP::close(int buffer) {

    bool ok = MPUSBClose((HANDLE) buffer);
    return ok;
}

bool driverLayerMCHP::sendInt(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendInt, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

bool driverLayerMCHP::sendCtrl(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendCtrl, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

bool driverLayerMCHP::sendIso(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendIso, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

bool driverLayerMCHP::sendBulk(int buffer, char *msg, int len, int timeout) {

    bool ok;
    char temp[MAX_LEN_MSG];
    DWORD tsend;

    sprintf(temp,"DriverLayer ==> SendBulk, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ok = (bool) MPUSBWrite((HANDLE) buffer, msg, len, &tsend, timeout);
    sprintf(temp,"Se enviaron %d bytes.",(int) tsend);
    l->printLog(temp, true, true);
    l->printLogLn();
    return ok;
}

char* driverLayerMCHP::receiveInt(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv;
    DWORD esperado = explenrecv;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveInt, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

char* driverLayerMCHP::receiveCtrl(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv;
    DWORD esperado = explenrecv;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveCtrl, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

char* driverLayerMCHP::receiveIso(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv;
    DWORD esperado = explenrecv;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveIso, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

char* driverLayerMCHP::receiveBulk(int buffer, int& recv, bool& ok, int timeout) {

    char *msg = new char[MAX_LEN_MSG];
    char temp[MAX_LEN_MSG];
    DWORD trecv;
    DWORD esperado = explenrecv;

    ok = (bool) MPUSBRead((HANDLE) buffer, msg, esperado, &trecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveBulk, Endpoint = %d",buffer);
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (unsigned int i=0; i< trecv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",(int) trecv);
    l->printLog(temp, true, true);
    l->printLogLn();
    recv = trecv;
    return msg;
}

#endif
